<?php

/*******************************************************************************
    RECUPERATION DES DONNES DU FLUX XML jour.xml
    
    Auteur : Famille de saint Joseph, 2006
    Version : 0.2
    Ressources : miniXML 1.3.0 (http://minixml.psychogenic.com/)
    Installation : 
        le prsent script : /xml/testxml.php
        la classe miniXML : /xml/minixml.inc.php
                            /xml/classes/doc.inc.php
                            /xml/classes/element.inc.php
                            /xml/classes/node.inc.php
                            /xml/classes/treecomp.inc.php
*******************************************************************************/
                            
require_once('minixml.inc.php');
$xmlString = file_get_contents("http://www.homelies.fr/jour.xml");
$XMLDoc = new MiniXMLDoc();
$XMLDoc->fromString($xmlString);
$fsj = array();

/*******************************************************************************
    ENTETE DU FLUX FSJ :
    <liturgie>
        |______ titre (titre gnral, facultatif)
        |______ lien (lien vers le site de l'auteur, facultatif)
        |______ description (description du flux, facultatif)
        |______ logo (logo des homlies avec lien le site, OBLIGATOIRE)
                    |__ url (url de l'image  afficher)
                    |__ titre (texte alt de l'image ou title du lien)
                    |__ lien (lien de l'image)
        |______ droits (droits, facultatif)
        |______ ordo (jour liturgique)
        
*******************************************************************************/ 

$url = $XMLDoc->getElementByPath('fsj/liturgie/logo/url');
$titre = $XMLDoc->getElementByPath('fsj/liturgie/logo/titre');
$lien = $XMLDoc->getElementByPath('fsj/liturgie/logo/lien');
$fsj['logo'] = array (
                'url' => $url->getValue(),
                'titre' => $titre->getValue(),
                'lien' => $lien->getValue()
                );

/*******************************************************************************
    ORDO
    <liturgie>
        |______<ordo>
                |_____ titre (titre du jour liturgique "Nol",...)
                |_____ DateCourte (date sous la forme "vendredi 13")
                |_____ DateLongue (date "vendredi 13 fvrier 2042")
                |_____ couleur (Vert,Blanc,Rouge,Violet)
                |_____ jour (lundi, mardi, etc)
                |_____ semaine (semaine du temps en cours : 21me semaine)
                |_____ temps (temps ordinaire, avent, carme,...)
                |_____ annee (A,B,C)
                |_____ messe (messes clbres)

*******************************************************************************/

$ordo = $XMLDoc->getElementByPath('fsj/liturgie/ordo');
$ordoElement = $ordo->getAllChildren();

$titre = $XMLDoc->getElementByPath('fsj/liturgie/ordo/titre');
$fsj['titre'] = $titre->getValue();


/*******************************************************************************
    MESSE
    <ordo>
        |_____<messe>
                |_____ titre (titre de la messe "Messe de l'aurore",...)
                |_____ lecture (les lectures de la messe)
                        |______ index (numro d'ordre dans la messe)
                        |______ rang (numro d'ordre des lectures, hors psaumes, cantiques et vangile)
                        |______ ref (rfrence biblique)
                        |______ texte
                        |______ media (fichier multimedia associ)
                                    |_____ ext (extension du fichier)
                                    |_____ url (url du fichier)                                    
                                    |_____ taille (taille du fichier)
                                    |_____ dure (dure de l'enregistrement)
                        |______ url (page de la lecture sur le site)
                |_____ homelie
                        |______ texte
                        |______ auteur
                        |______ media (fichier multimedia associ)
                                    |_____ ext (extension du fichier)
                                    |_____ url (url du fichier)                                    
                                    |_____ taille (taille du fichier)
                                    |_____ dure (dure de l'enregistrement)
                        |______ url (page de l'homlie sur le site)

*******************************************************************************/
$nbreLectures = 0;
for($i=0; $i < $ordo->numChildren(); $i++) {
	
    if ( $ordoElement[$i]->name()=='messe' ) {
    
        $messeElement = $ordoElement[$i]->getAllChildren();

        for ($j=0; $j < $ordoElement[$i]->numChildren(); $j++) {   
                 
            if ( $messeElement[$j]->name()=='titre' ) {
            
                $fsj['messe'] = $messeElement[$j]->getValue();
                
            } elseif ( $messeElement[$j]->name()=='lecture' ) {

                $ref = $messeElement[$j]->getElement('ref');
                $texte = $messeElement[$j]->getElement('texte');                
                $fsj['lecture'][] = array(  'ref' => $ref->getValue(),
                                            'texte' => $texte->getValue()
                                         );
                $nbreLectures++;
                
            } elseif ( $messeElement[$j]->name()=='homelie' ) {                

                $auteur = $messeElement[$j]->getElement('auteur');
                $fsj['homelie']['auteur'] = $auteur->getValue();
                $texte = $messeElement[$j]->getElement('texte');
                $fsj['homelie']['texte'] = $texte->getValue();
                
            }
            

        } // boucle messeElements
        
    } // fin IF ordoElement=messe
    	
} // fin de FOR ordoElements


/*******************************************************************************
    Affichage
*******************************************************************************/

echo '<a href="'.$fsj['logo']['lien'].'"><img src="'.$fsj['logo']['url'].'" border="0" alt="'.$fsj['logo']['titre'].'" /></a>';
echo '<hr />';
echo 'Titre du jour : '.$fsj['titre'];
echo '<hr />';
echo 'Titre de la messe : '.$fsj['messe'];
echo '<hr />';
echo 'Homlie de '.$fsj['homelie']['auteur'].' : '.$fsj['homelie']['texte'];
echo '<hr />';
echo 'Lectures : ';
for ($i=0; $i<$nbreLectures; $i++) {
    echo '<strong>'.$fsj['lecture'][$i]['ref'].'</strong><br />'.$fsj['lecture'][$i]['texte'].'<br /><br />';
}

?>
